/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.webservices;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertAES;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.adaptors.webservices.AxisCall;
import filenet.vw.integrator.adaptors.webservices.WSRequestOperation;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSPart;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSPortType;
import filenet.ws.listener.axis.rm.WSRMSequenceInfo;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSEncString;
import filenet.ws.utils.WSMessageHelper;
import filenet.ws.utils.att.IWSAttLoader;
import filenet.ws.utils.att.IWSAttSession;
import java.net.ConnectException;
import java.text.MessageFormat;
import org.apache.axis.AxisFault;
import org.apache.sandesha.util.PolicyLoader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSInvokeOperation
extends WSRequestOperation {
    protected static final String m_className = "WSInvokeOperation";
    private String cmUserName;
    private String cmPassword;
    protected static String ReplyHeaderTemplate = null;
    protected static String EndPointReferenceTemplate = null;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 00:52:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.66  $";
    }

    public WSInvokeOperation(VWSession PESession, IWSAttSession WSAttSession, int wsTimeout, boolean traceIt, String traceFile, long traceFileSize, long cacheTimeout, String listenerURL, boolean validateMessages, int tIndex, String cmUserName, String cmPassword) {
        super(PESession, WSAttSession, wsTimeout, traceIt, traceFile, traceFileSize, cacheTimeout, validateMessages, tIndex);
        this.cmUserName = cmUserName;
        this.cmPassword = cmPassword;
        this.m_listenerURL = listenerURL;
        this.m_wsLogger.setType("WS-Request[" + tIndex + "] invoke");
    }

    protected String getReplyHeader(String replySOAPAction, String wobNum, int WSDLVersion) throws VWException {
        String NS_PREFIX = WSConstants.getWSConstants((int)WSDLVersion).P8BPM_NS_GENERIC;
        String s = MessageFormat.format(ReplyHeaderTemplate, NS_PREFIX, wobNum, this.getURL4Reply(), NS_PREFIX, replySOAPAction);
        if (logger.isFinest()) {
            logger.finest(m_className, "getReplyHeader", s);
        }
        return s;
    }

    private String getURL4Reply() throws VWException {
        return this.m_listenerURL + "/wscp" + WSConstants.UTF8Encode(this.m_PESession.getConnectionPointName());
    }

    public String invoke(VWStepElement se) throws VWException {
        String s;
        String resStatus = "OK";
        boolean oneWay = false;
        String m_method = "invoke";
        logger.entering(m_className, "invoke");
        boolean async = false;
        boolean bRM = false;
        boolean poWS = false;
        int rmFlag = 0;
        String wobNum = se.getWorkObjectNumber();
        boolean fromWSDLRef = false;
        String soapAction = null;
        String soapAddress = null;
        try {
            WSParam[] inParams;
            String bindingInputNS;
            WSOperation m_wsop;
            String replyHeader;
            WSBindingOperation SOAPOp;
            WSPort m_port;
            WSDefinition m_definition;
            String soapHeaders;
            String wfNum;
            block93: {
                this.m_wcName = se.getWorkClassName();
                this.m_endPoint = (String)se.getParameterValue("WsdlEndPoint");
                this.m_portType = (String)se.getParameterValue("PortType");
                this.m_op = (String)se.getParameterValue("Op");
                this.m_inputMsg = (String)se.getParameterValue("InputMsg");
                this.m_endPointRef = (String)se.getParameterValue("EndPointRef");
                this.m_wsFolder = (VWAttachment)se.getParameterValue("WsFolder");
                Object value = se.getParameterValue("ReliableFlag");
                if (value != null && value instanceof Boolean) {
                    bRM = (Boolean)value;
                }
                try {
                    this.m_inputMsgName = (String)se.getParameterValue("InputMsgName");
                    this.m_outputMsgName = (String)se.getParameterValue("OutputMsgName");
                    this.m_wsdlRef = (String)se.getParameterValue("PartnerlinkWsdlRef");
                    this.m_partnerLinkRef = (String)se.getParameterValue("PartnerlinkRef");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.traceData();
                WSInvokeOperation.checkRequiredParameters(this.m_endPoint, "WsdlEndPoint");
                WSInvokeOperation.checkRequiredParameters(this.m_portType, "PortType");
                WSInvokeOperation.checkRequiredParameters(this.m_op, "Op");
                String wfName = se.getWorkflowName();
                wfNum = se.getWorkflowNumber();
                if (!WSInvokeOperation.isEmpty(this.m_partnerLinkRef)) {
                    this.m_wsLogger.append("PartnerlinkRef=").append(this.m_partnerLinkRef).eoln();
                }
                this.m_wsLogger.append("EndPoint=").append(this.m_endPoint).eoln();
                this.m_wsLogger.append("PortType=").append(this.m_portType).eoln();
                this.m_wsLogger.append("Operation=").append(this.m_op).eoln();
                this.m_wsLogger.append("InputMsgName=").append(this.m_inputMsgName).eoln();
                this.m_wsLogger.append("OutputMsgName=").append(this.m_outputMsgName).eoln();
                this.m_wsLogger.append("WorkflowName=").append(wfName).eoln();
                this.m_wsLogger.append("WorkflowNumber=").append(wfNum).eoln();
                this.m_wsLogger.append("WorkObjectNumber=").append(wobNum).eoln();
                this.m_wsLogger.append("Initial InputMsg=").append(this.m_inputMsg).eoln();
                if (!WSInvokeOperation.isEmpty(this.m_wsdlRef)) {
                    String s2 = null;
                    if (this.m_wsdlRef.startsWith("cemp:")) {
                        s2 = this.m_wsdlRef;
                    } else {
                        int x = this.m_wsdlRef.indexOf("address");
                        if (x == -1) {
                            x = 0;
                        }
                        s2 = this.m_wsdlRef.substring(x, Math.min(x + 128, this.m_wsdlRef.length()));
                    }
                    this.m_wsLogger.append("PartnerlinkWsdlRef=....").append(s2).append("...").eoln();
                }
                if (this.m_wsFolder != null && this.m_wsFolder.getType() == 0) {
                    this.m_wsFolder = null;
                }
                if (this.m_wsFolder != null && this.m_wsFolder.getType() != 2) {
                    logger.warning(m_className, "invoke", "WSFolder is not defined.  Attachment operations will be ignored for " + wfName + ":" + wobNum);
                    this.m_wsFolder = null;
                }
                soapHeaders = null;
                String wsdlEndPoint = this.m_endPoint;
                if (!WSInvokeOperation.isEmpty(this.m_endPointRef)) {
                    this.m_wsLogger.append("Initial EndPointRef=").append(this.m_endPointRef).eoln();
                    this.m_endPointRef = WSEncString.Decode(this.m_endPointRef, wfNum);
                    VWXMLWrapper endpointRef_doc = null;
                    try {
                        endpointRef_doc = new VWXMLWrapper(this.m_endPointRef);
                    }
                    catch (Exception e) {
                        VWException vwe = new VWException("ws.WSOperations.invalidEndPointRef", "Invalid F_EndPointRefXXX. {0}", e.getMessage());
                        logger.throwing(m_className, "invoke", vwe);
                        throw vwe;
                    }
                    soapAddress = VWXMLWrapper.getNodeValue(endpointRef_doc.getRootNode(), "Address");
                    Node refPropsNode = VWXMLWrapper.getNodeNamed(endpointRef_doc.getRootNode(), "ReferenceProperties");
                    if (refPropsNode != null) {
                        int nNodes;
                        NodeList nodeList = refPropsNode.getChildNodes();
                        int n = nNodes = nodeList == null ? 0 : nodeList.getLength();
                        if (nNodes > 0) {
                            StringBuffer buf = new StringBuffer();
                            for (int k = 0; k < nNodes; ++k) {
                                buf.append(endpointRef_doc.toXML(nodeList.item(k)));
                            }
                            String string = soapHeaders = buf.length() > 0 ? buf.toString().trim() : null;
                        }
                        if (soapHeaders != null && logger.isFinest()) {
                            logger.finest(m_className, "invoke", "soapHeaders=" + soapHeaders);
                        }
                    }
                    if (WSInvokeOperation.isEmpty(wsdlEndPoint = VWXMLWrapper.getNodeValue(endpointRef_doc.getRootNode(), "WSDLEndPoint")) && (wsdlEndPoint = this.m_endPoint) != null && !wsdlEndPoint.endsWith("?wsdl") && !WSInvokeOperation.isEmpty(this.m_partnerLinkRef)) {
                        wsdlEndPoint = wsdlEndPoint + "?wsdl";
                    }
                }
                m_definition = null;
                try {
                    long inactivityTimeOut = 600000L;
                    long baseRetryInterval = 3000L;
                    if (bRM) {
                        inactivityTimeOut = PolicyLoader.getInstance().getInactivityTimeout();
                        baseRetryInterval = PolicyLoader.getInstance().getBaseRetransmissionInterval();
                    }
                    if (!WSInvokeOperation.isEmpty(this.m_wsdlRef) && !this.m_wsdlRef.startsWith("cemp:")) {
                        this.m_wsDefinition = m_definition = WSDefinition.getWSDefinitionFromString(this.m_wsdlRef);
                        fromWSDLRef = true;
                    } else {
                        m_definition = this.getWSDLDefinition(wsdlEndPoint, this.m_endPoint, baseRetryInterval, inactivityTimeOut);
                    }
                }
                catch (Exception ex) {
                    logger.throwing(m_className, "invoke", ex);
                    throw ex;
                }
                this.m_wsLogger.append("Using WSDLEndPoint=").append(this.m_endPoint).eoln();
                m_port = m_definition.getDefaultPort(this.m_portType);
                SOAPOp = m_port.getBindingOperation(this.m_op, this.m_inputMsgName, this.m_outputMsgName);
                if (SOAPOp == null) {
                    VWException vwex = new VWException("ws.WSOperations.noSOAPOp", "Cannot find binding operation for op={0}, port={1}, service={2}.", this.m_op, this.m_portType, this.m_endPoint);
                    logger.throwing(m_className, "invoke", vwex);
                    throw vwex;
                }
                if (!SOAPOp.isSoapBinding()) {
                    VWException vwex = new VWException("ws.WSOperations.unsupportedBinding", "Unsupported binding.");
                    logger.throwing(m_className, "invoke", vwex);
                    throw vwex;
                }
                if (this.m_inputMsg != null) {
                    String s3 = "[WPSCORRID::%P8_SVC_NAME%%09%P8_REGNUM%%09%P8_WSID%%09%P8_WCID%%09%P8_WSTIMESTAMP%::WPSCORRID]";
                    if (this.m_inputMsg.contains(s3)) {
                        String newS = s3;
                        newS = newS.replaceAll("%P8_SVC_NAME%", this.m_PESession.getServerName());
                        newS = newS.replaceAll("%P8_REGNUM%", Integer.toString(this.m_PESession.getIsolatedRegion()));
                        newS = newS.replaceAll("%P8_WSID%", Integer.toString(se.getWorkSpaceId()));
                        newS = newS.replaceAll("%P8_WCID%", Integer.toString(se.getWorkClassId()));
                        long wsTimestamp = VWClassFactory.VWSession_getWsTimeStamp(this.m_PESession, 234L);
                        newS = newS.replaceAll("%P8_WSTIMESTAMP%", Long.toString(wsTimestamp / 1000L));
                        this.m_inputMsg = this.m_inputMsg.replace(s3, newS);
                    }
                    String[] schemaNS = m_definition.getSchemasTNS();
                    this.m_inputMsg = WSMessageHelper.updateMessageNamespaces(this.m_inputMsg, schemaNS);
                }
                soapAction = SOAPOp.getSoapAction();
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "soapAction=" + soapAction);
                }
                if (soapAction == null) {
                    soapAction = "";
                }
                if (soapHeaders != null && !WSInvokeOperation.isEmpty(this.m_wsdlRef) && !WSInvokeOperation.isEmpty(this.m_partnerLinkRef)) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", soapHeaders);
                    }
                    String uid = null;
                    String user = null;
                    String pw = null;
                    String propName = null;
                    if (this.m_partnerLinkRef != null) {
                        propName = "wps.uid." + this.m_partnerLinkRef;
                        uid = JVMSystemConstants.GetPrivilegedSystemProperty(propName);
                    }
                    if (uid == null) {
                        uid = JVMSystemConstants.GetPrivilegedSystemProperty("wps.uid");
                    }
                    if (uid != null) {
                        try {
                            VWAuthItem a = new VWConvertAES().getDString(uid);
                            user = a.getName();
                            pw = a.getPassword();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (user == null) {
                        user = this.cmUserName;
                    }
                    if (pw == null) {
                        pw = this.cmPassword;
                    }
                    if (soapHeaders.contains("%WID_WPS_USER%")) {
                        soapHeaders = soapHeaders.replaceAll("%WID_WPS_USER%", user);
                    }
                    if (soapHeaders.contains("%WID_WPS_PW%")) {
                        soapHeaders = soapHeaders.replaceAll("%WID_WPS_PW%", pw);
                    }
                    if (soapHeaders.contains("%WID_P8_ADDRESS%")) {
                        String newURL = this.getURL4Reply() + "/" + this.m_wcName;
                        soapHeaders = soapHeaders.replaceFirst("%WID_P8_ADDRESS%", newURL);
                    }
                    if (soapHeaders.contains("%WID_WPS_ACTION%")) {
                        String inputName = this.m_inputMsgName;
                        System.out.println(SOAPOp.getInputName());
                        if (inputName == null) {
                            inputName = SOAPOp.getInputName();
                        }
                        String wpsAction = m_definition.getTargetNameSpace() + "/" + this.m_portType + "/" + inputName;
                        soapHeaders = soapHeaders.replaceFirst("%WID_WPS_ACTION%", wpsAction);
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", "NEW:" + soapHeaders);
                    }
                }
                P8BPMSoapActionURI soapActionURI = null;
                replyHeader = null;
                WSPortType m_wsPortType = m_definition.getPortType(this.m_portType);
                m_wsop = m_wsPortType.getOperation(this.m_op, this.m_inputMsgName, this.m_outputMsgName);
                WSMessage outMsg = m_wsop.getOutMessage();
                oneWay = false;
                oneWay = outMsg == null || outMsg.getParts() == null || outMsg.getParts().length == 0;
                try {
                    soapActionURI = new P8BPMSoapActionURI(soapAction);
                    poWS = true;
                    boolean bl = async = m_wsop.getOutMessage() != null || m_wsop.getFaults() != null;
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", "async=" + new Boolean(async).toString());
                    }
                    if (async) {
                        this.m_wsLogger.setType("WS-Request[" + this.m_tIndex + "] invoke-async-reply");
                        if (this.m_wsFolder != null) {
                            soapActionURI.setWsFolderId(this.m_wsFolder.getId());
                            soapActionURI.setWsLibraryId(this.m_wsFolder.getLibraryName());
                        }
                        soapActionURI.setReply(wobNum, this.m_PESession.getIsolatedRegion());
                        replyHeader = this.getReplyHeader(soapActionURI.toStringEx(), wobNum, soapActionURI.getWSDLVersion());
                    }
                }
                catch (Exception e) {
                    poWS = false;
                    if (!logger.isFinest()) break block93;
                    logger.finest(m_className, "invoke", "not our soapAction");
                }
            }
            if (WSInvokeOperation.isEmpty(soapAddress)) {
                soapAddress = !fromWSDLRef ? m_port.getEndpoint() : this.m_endPoint;
            }
            if (WSInvokeOperation.isEmpty(this.m_endPointRef)) {
                this.m_endPointRef = MessageFormat.format(EndPointReferenceTemplate, soapAddress);
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "Setting EndPointRef=" + this.m_endPointRef);
                }
                se.setParameterValue("EndPointRef", this.m_endPointRef, true);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "invoke", "soapAddress=" + soapAddress);
            }
            String soapStyle = SOAPOp.getSoapStyle();
            this.getNameSpaces(m_definition);
            boolean isDocument = soapStyle.equals("document");
            this.checkInlineAttachments();
            this.m_inputMsg = WSEncString.Decode(this.m_inputMsg, wfNum);
            if (!isDocument) {
                WSMessage SOAPOutMsg;
                if (this.m_inputMsg != null) {
                    this.m_inputMsg = SOAPOp.addedBindingInfoToInParam(this.m_inputMsg);
                }
                if ((SOAPOutMsg = m_definition.getOperation(this.m_portType, this.m_op, this.m_inputMsgName, this.m_outputMsgName).getOutMessage()) != null) {
                    int nParts;
                    WSPart[] parts = SOAPOutMsg.getParts();
                    int n = nParts = parts == null ? 0 : parts.length;
                    if (nParts > 0) {
                        this.m_rpcOutMsgParts = new String[nParts];
                        this.m_rpcOutAccessors = new String[nParts];
                        for (int i = 0; i < nParts; ++i) {
                            this.m_rpcOutMsgParts[i] = parts[i].getPart().getName();
                            this.m_rpcOutAccessors[i] = this.m_op + this.m_rpcOutMsgParts[i];
                        }
                        if (logger.isFinest()) {
                            logger.finest(m_className, "invoke", "RPC accessors = " + Logger.asString(this.m_rpcOutAccessors) + "\nRPC out parts = " + Logger.asString(this.m_rpcOutMsgParts));
                        }
                    }
                }
            }
            if (WSInvokeOperation.isEmpty(bindingInputNS = SOAPOp.getBindingInput().getSoapBodyNamespace())) {
                bindingInputNS = this.m_wsDefinition.getNamespacePrefix(this.m_wsDefinition.getTargetNameSpace());
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "invoke", "bindingInputNS=" + bindingInputNS);
            }
            WSMessage SOAPMsg = null;
            try {
                SOAPMsg = m_definition.getOperation(this.m_portType, this.m_op, this.m_inputMsgName, this.m_outputMsgName).getInMessage();
            }
            catch (Exception ex) {
                logger.throwing(m_className, "invoke", ex);
                throw ex;
            }
            if (SOAPMsg != null && (inParams = SOAPMsg.getParamList()) != null && inParams.length > 0 && WSInvokeOperation.isEmpty(this.m_inputMsg)) {
                throw new VWException("ws.WSOperations.missingInputMessage", "The input parameter is empty for method {0} of {1}.", this.m_op, this.m_endPoint);
            }
            WSRequestOperation.MIMEHandler mimeHandler = new WSRequestOperation.MIMEHandler(this, SOAPMsg, SOAPOp, true);
            IWSAttLoader[] docs = mimeHandler.getDocs();
            Integer v = (Integer)se.getParameterValue("Status");
            if (v != null) {
                this.m_validateMessages = (v & 0x80) > 0;
            }
            boolean bl = this.m_validateMessages = this.m_validateMessages && isDocument && docs == null && !mimeHandler.hasMIME() && m_definition.getValidateUsingSchema();
            if (this.m_validateMessages && !WSInvokeOperation.isEmpty(this.m_inputMsg)) {
                this.validateMessage(m_definition);
            }
            if (bRM) {
                if (!poWS) {
                    if (soapAction != null && soapAction.length() == 0) {
                        soapAction = "urn:wsrm:" + m_wsop.getName();
                    }
                } else {
                    rmFlag = 8;
                }
                rmFlag = oneWay ? ++rmFlag : (async ? (rmFlag += 3) : (rmFlag += 2));
            }
            new AxisCall().invokeSOAPViaSAAJ(this, soapAction, soapAddress, soapHeaders, replyHeader, isDocument, oneWay, rmFlag, wobNum, bindingInputNS, docs);
        }
        catch (Throwable t) {
            logger.throwing(m_className, "invoke", t);
            this.m_wsLogger.append("EXCEPTION=").append(VWException.DescribeThrowableCompletely(t));
            if (t instanceof NullPointerException) {
                this.m_fault = "VWException";
                this.m_outputMsg = WSRequestOperation.getClientName() + (soapAddress != null ? " [soapAddress:" + soapAddress + "] " : "") + "NullPointerException";
            } else {
                this.m_fault = t.getClass().getName();
                this.m_outputMsg = WSRequestOperation.getClientName() + this.m_fault + (soapAddress != null ? " [soapAddress:" + soapAddress + "] " : "") + t.getMessage();
            }
            if (rmFlag != 0 && wobNum != null) {
                String rmExtraDetails = null;
                WSRMSequenceInfo seqInfo = WSRMSequenceInfo.getSequenceInfoByWobnum(wobNum);
                if (seqInfo != null) {
                    rmExtraDetails = seqInfo.getSeqStatusMsg();
                }
                if (rmExtraDetails != null) {
                    this.m_outputMsg = this.m_outputMsg + "\n " + rmExtraDetails;
                }
            }
            this.m_wsLogger.append("Fault=").append(this.m_fault).eoln();
            this.m_wsLogger.append("Detail=").append(this.m_outputMsg).eoln();
            if (t.getCause() != null && t.getCause() instanceof AxisFault) {
                AxisFault fe = (AxisFault)t.getCause();
                if (fe.detail != null && fe.detail instanceof ConnectException) {
                    this.m_status = 2;
                }
            }
            this.m_status = t instanceof ConnectException ? 2 : 3;
        }
        if (this.m_status == -1) {
            if (logger.isFinest()) {
                logger.finest(m_className, "invoke", "checking soap fault..");
            }
            if (!WSInvokeOperation.isEmpty(this.m_fault)) {
                this.m_wsLogger.append("Fault=").append(this.m_fault).eoln();
                this.m_wsLogger.append("Detail=").append(this.m_outputMsg).eoln();
                this.m_status = 3;
            } else {
                this.m_status = async ? 1 : 0;
            }
        }
        this.m_wsLogger.append("Status=").append(Integer.toString(this.m_status)).eoln();
        this.m_wsLogger.println(null);
        this.saveParametersToStepElement(se);
        resStatus = resStatus + ",wsStatus=" + this.m_status + ",";
        if (!WSInvokeOperation.isEmpty(this.m_fault)) {
            resStatus = resStatus + ",fault=" + this.m_fault + ",detail=" + this.m_outputMsg;
        }
        if (async && this.m_status == 1) {
            if (logger.isFinest()) {
                logger.finest(m_className, "invoke", "Calling doSave(true) wobnum =" + wobNum);
            }
            try {
                se.doSave(true);
            }
            catch (Throwable tS) {
                logger.throwing(m_className, "invoke", tS);
                s = new VWString("ws.WSOperations.DoSaveFailed", "The invoke operation could not be completed. The step element {0} could not be saved due to the following exception: {1}").toString(wobNum, VWException.DescribeThrowableAndItsCause(tS));
                logger.warning(m_className, "invoke", s);
            }
        } else {
            if (logger.isFinest()) {
                logger.finest(m_className, "invoke", "Calling doDispatch. wobnum = " + wobNum);
            }
            try {
                se.doDispatch();
            }
            catch (Throwable tD) {
                if (tD.getLocalizedMessage().indexOf("d56d000c") >= 0) {
                    se.doLock(true);
                    this.saveParametersToStepElement(se);
                    se.doDispatch();
                }
                logger.throwing(m_className, "invoke", tD);
                s = new VWString("ws.WSOperations.DoDispatchFailed", "The invoke operation could not be completed. The step element {0} could not be dispatched due to the following exception: {1}").toString(wobNum, VWException.DescribeThrowableAndItsCause(tD));
                logger.warning(m_className, "invoke", s);
                resStatus = s;
            }
        }
        logger.exiting(m_className, "invoke");
        return resStatus;
    }

    private void saveParametersToStepElement(VWStepElement se) throws VWException {
        se.setParameterValue("OutputMsg", this.m_outputMsg, true);
        se.setParameterValue("FaultName", this.m_fault, true);
        se.setParameterValue("Status", new Integer(this.m_status), true);
    }

    public void invokeTest(String endPoint, String portType, String operation, String inputMsg) throws VWException {
        String m_method = "invokeTest";
        logger.entering(m_className, "invokeTest");
        try {
            String soapAction = null;
            String soapAddress = null;
            String soapHeaders = null;
            this.m_endPoint = endPoint;
            this.m_portType = portType;
            this.m_op = operation;
            this.m_inputMsg = inputMsg;
            this.m_endPointRef = null;
            this.m_wsFolder = null;
            if (logger.isLoggable(Level.FINEST)) {
                this.traceData();
            }
            if (this.m_endPoint == null || this.m_portType == null || this.m_op == null) {
                throw new VWException("ws.WSOperations.missingParams", "Missing required parameters.");
            }
            this.m_wsLogger.append("EndPoint=").append(this.m_endPoint).eoln();
            this.m_wsLogger.append("PortType=").append(this.m_portType).eoln();
            this.m_wsLogger.append("Operation=").append(this.m_op).eoln();
            this.m_wsLogger.append("Initial InputMsg=").append(this.m_inputMsg).eoln();
            WSDefinition m_definition = null;
            try {
                m_definition = this.getWSDLDefinition(this.m_endPoint);
            }
            catch (Exception we) {
                logger.throwing(m_className, "invokeTest", we);
                throw we;
            }
            WSPort m_port = m_definition.getDefaultPort(this.m_portType);
            WSBindingOperation SOAPOp = m_port.getBindingOperation(this.m_op, this.m_inputMsgName, this.m_outputMsgName);
            if (SOAPOp == null) {
                VWException vwex = new VWException("ws.WSOperations.noSOAPOp", "Cannot find binding operation for op={0}, port={1}, service={2}.", this.m_op, this.m_portType, this.m_endPoint);
                logger.throwing(m_className, "invokeTest", vwex);
                throw vwex;
            }
            if (!SOAPOp.isSoapBinding()) {
                VWException vwex = new VWException("ws.WSOperations.unsupportedBinding", "Unsupported binding.");
                logger.throwing(m_className, "invokeTest", vwex);
                throw vwex;
            }
            soapAction = SOAPOp.getSoapAction();
            if (logger.isFinest()) {
                logger.finest(m_className, "invokeTest", "soapAction=" + soapAction);
            }
            if (soapAction == null) {
                soapAction = "";
            }
            WSPortType m_wsPortType = m_definition.getPortType(this.m_portType);
            WSOperation m_wsop = m_wsPortType.getOperation(this.m_op, this.m_inputMsgName, this.m_outputMsgName);
            if (soapAddress == null) {
                soapAddress = m_port.getEndpoint();
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "invokeTest", "soapAddress=" + soapAddress);
            }
            String soapStyle = SOAPOp.getSoapStyle();
            this.getNameSpaces(m_definition);
            boolean isDocument = soapStyle.equals("document");
            if (!isDocument) {
                String bindingInputNS;
                WSMessage SOAPOutMsg;
                boolean skipIt = true;
                if (!skipIt && this.m_inputMsg != null) {
                    this.m_inputMsg = SOAPOp.addedBindingInfoToInParam(this.m_inputMsg);
                }
                if ((SOAPOutMsg = m_definition.getOperation(this.m_portType, this.m_op, this.m_inputMsgName, this.m_outputMsgName).getOutMessage()) != null) {
                    int nParts;
                    WSPart[] parts = SOAPOutMsg.getParts();
                    int n = nParts = parts == null ? 0 : parts.length;
                    if (nParts > 0) {
                        this.m_rpcOutMsgParts = new String[nParts];
                        this.m_rpcOutAccessors = new String[nParts];
                        for (int i = 0; i < nParts; ++i) {
                            this.m_rpcOutMsgParts[i] = parts[i].getPart().getName();
                            this.m_rpcOutAccessors[i] = this.m_op + this.m_rpcOutMsgParts[i];
                        }
                        if (logger.isFinest()) {
                            logger.finest(m_className, "invokeTest", "RPC accessors = " + Logger.asString(this.m_rpcOutAccessors) + "\nRPC out parts = " + Logger.asString(this.m_rpcOutMsgParts));
                        }
                    }
                }
                if (WSInvokeOperation.isEmpty(bindingInputNS = SOAPOp.getBindingInput().getSoapBodyNamespace())) {
                    bindingInputNS = this.m_wsDefinition.getNamespacePrefix(this.m_wsDefinition.getTargetNameSpace());
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "invokeTest", "bindingInputNS=" + bindingInputNS);
                }
                new AxisCall().invokeSOAPViaSAAJ(this, soapAction, soapAddress, soapHeaders, null, isDocument, false, 0, null, bindingInputNS, null);
            }
        }
        catch (Throwable t) {
            logger.throwing(m_className, "invokeTest", t);
            if (t instanceof NullPointerException) {
                this.m_fault = "VWExceptiion";
                this.m_outputMsg = "NullPointerException";
            } else {
                this.m_fault = t.getClass().getName();
                this.m_outputMsg = t.getMessage();
            }
            this.m_wsLogger.append("Fault=").append(this.m_fault).eoln();
            this.m_wsLogger.append("Detail=").append(this.m_outputMsg).eoln();
            this.m_status = t instanceof ConnectException ? 2 : 3;
        }
        this.m_wsLogger.append("Status=").append(Integer.toString(this.m_status)).eoln();
        this.m_wsLogger.println(null);
        logger.exiting(m_className, "invokeTest");
    }

    static {
        ReplyHeaderTemplate = new StringBuffer(512).append("<ReplyHeader xmlns=\"{0}").append("\">\n<MessageID xmlns=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\">\n{1}</MessageID><ReplyTo xmlns=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\">\n<Address>{2}/ASyncReply</Address>\n<ReferenceProperties><ReplySOAPAction xmlns=\"{3}").append("\">\n{4}\n</ReplySOAPAction></ReferenceProperties></ReplyTo></ReplyHeader>").toString();
        EndPointReferenceTemplate = new StringBuffer(256).append("<wsa:EndPointReference xmlns:wsa=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\"><wsa:Address>{0}</wsa:Address></wsa:EndPointReference>").toString();
    }
}

